<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="text()|@*" />
  <xsl:template match="*" />
  
  <xsl:template match="/">
	<html xmlns:html="http://www.w3.org/1999/xhtml">
		<head>
			<title>Baum <xsl:value-of select="/tree/@contextid"/></title>
			<script type="text/javascript">
				var belenusHome = parent.belenusHome;
				var overcolor = "#B0C4DE";
				var outcolor = "#dfdfdf";
				
				function over(elem) {
				  var span;
				  while(elem.hasChildNodes()) {
					var x1 = elem.firstChild.nodeName;
					if(x1.toLowerCase() == "div") {
					  span = elem.firstChild;
					  break;
					}
					elem = elem.firstChild;
				  }
				  span.style.backgroundColor = overcolor;
				}
				
				function out(elem) {
				  var span;
				  while(elem.hasChildNodes()) {
					var x1 = elem.firstChild.nodeName;
					if(x1.toLowerCase() == "div") {
					  span = elem.firstChild;
					  break;
					}
					elem = elem.firstChild;
				  }
				  span.style.backgroundColor =outcolor;
				}
		
				function j(x) {
					belenusHome.eventHandler("OpenLink","URL=parts:"+belenusHome.currentTreePath+"/"+x);
				}
				function d(x) {
					belenusHome.eventHandler("OpenLink","URL="+x);
				}				
			</script>
			<link rel="stylesheet" type="text/css" href="./viewer/custom/content.css"/>
			<style type="text/css">
				.x {
					width:120px;
					height:120px;
					border:1px dashed black;
					background-color:#dfdfdf;
					padding:4px;
					overflow:hidden;
				}
				
				table {
					display:inline;
					margin-bottom:0px;
					padding-bottom:0px;
				}
				
				a {
					border:0px solid black;
					padding:0px;
					margin:0px;
				}								
				
				a:hover {
					font-size:1px;
					padding:0px;		
					margin:0px;
					text-decoration:none;
				}
			</style>
		</head>
		<body style="padding:0px;margin:0px;">
						<xsl:apply-templates select="/tree/*" />
	   </body>
	</html>
  </xsl:template>
  
						  <xsl:template match="folder">
		<a>
			<xsl:attribute name="href">javascript://</xsl:attribute>
			<xsl:attribute name="onmouseover">over(this);top.status=this.title;return true</xsl:attribute>
			<xsl:attribute name="onmouseout">out(this)</xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="a[1]/text()"/></xsl:attribute><table cellpadding="1" cellspacing="1" border="0"><tr><td><div class="x">
			<xsl:attribute name="onclick">javascript:j('<xsl:value-of select="@contextid"/>');</xsl:attribute>
			<img src="viewer/custom/images/0004.gif" style="float:right" border="0"/>
			<xsl:value-of select="a[1]/text()"/></div></td></tr></table>
							</a>								
						  </xsl:template>  
						  
						  <xsl:template match="document">
		<a>
			<xsl:attribute name="href">javascript://</xsl:attribute>
			<xsl:attribute name="onmouseover">over(this);top.status=this.title;return true</xsl:attribute>
			<xsl:attribute name="onmouseout">out(this)</xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="a[1]/text()"/></xsl:attribute><table cellpadding="1" cellspacing="1" border="0"><tr><td><div class="x">
			<xsl:attribute name="onclick">javascript:j('<xsl:value-of select="@contextid"/>');</xsl:attribute>
			<img src="viewer/custom/images/0008.gif" style="float:right" border="0"/>
			<xsl:value-of select="a[1]/text()"/></div></td></tr></table>
							</a>								
						  </xsl:template>  				
						  
						  <xsl:template match="device">
		<a>
			<xsl:attribute name="href">javascript://</xsl:attribute>
			<xsl:attribute name="onmouseover">over(this);top.status=this.title;return true</xsl:attribute>
			<xsl:attribute name="onmouseout">out(this)</xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="a[1]/text()"/></xsl:attribute><table cellpadding="1" cellspacing="1" border="0"><tr><td><div class="x">
			<xsl:attribute name="onclick">javascript:j('<xsl:value-of select="@contextid"/>');</xsl:attribute>
			<img src="viewer/custom/images/0006.gif" style="float:right" border="0"/>
			<xsl:value-of select="a[1]/text()"/></div></td></tr></table>
							</a>								
						  </xsl:template>  								  		  

</xsl:stylesheet>
